#include <p30fxxxx.h>
#include <timer.h>

/* These devices support Timers 4 and 5 */
#if defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__) || defined(__dsPIC30F3011__)  || \
    defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5011__) || \
    defined(__dsPIC30F6011__) || defined(__dsPIC30F6012__) || defined(__dsPIC30F5013__) || \
    defined(__dsPIC30F6013__) || defined(__dsPIC30F6014__) || defined(__dsPIC30F4013__) || \
    defined(__dsPIC30F5015__)

/********************************************************************
*    Function Name:  WriteTimer45                                   *
*    Description:    This routine writes a least 16-bit value       *
                     to Timer4 and Msb into Timer5                  *
*    Parameters:     unsigned long				    *
*    Return Value:   None                                           *
********************************************************************/

void WriteTimer45( unsigned long timer)
{   
    TMR5HLD = (timer>>16);
    TMR4 = timer;       /* LSB to Timer4 and MSB to Timer5HLD */          
}

#endif 
